<?php
/**
 *
 * Let's Review Blocks
 *
 * @since      3.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/admin
 */

class Lets_Review_Blocks {

    public $slug;
    public $version;
    public $url;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	*/
	public function __construct( $slug = '', $version = '', $url = '' ) {
		$this->slug    = $slug;
		$this->version = $version;
		$this->url     = $url;
	}

	/**
	 * Enqueue assets
	 *
	 * @since 1.0.0
	 */
	function lets_review_editor_assets() {

		wp_enqueue_script(
			'lets-review-block-js',
			esc_url( $this->url . 'admin/blocks/dist/blocks.build.js' ),
			array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-compose' ),
			$this->version,
			true
		);
		$args = self::lets_review_block_filters();
		wp_localize_script(
			'lets-review-block-js',
			'letsReviewBlockJS',
			array(
				'args' => $args,
			)
		);

		wp_enqueue_style(
			'lets-review-block-editor-css',
			esc_url( $this->url . 'admin/blocks/dist/blocks.editor.build.css' ),
			array( 'wp-edit-blocks' ),
			$this->version
		);
		$rtl = is_rtl() ? '-rtl' : '';
		wp_enqueue_style(
			'lets-review-editor-css',
			esc_url( $this->url . 'assets/css/style.min' . $rtl . '.css' ),
			array( 'wp-edit-blocks' ),
			$this->version
		);
	}

	function lets_review_block_category( $categories, $post ) {
		return array_merge(
			$categories,
			array(
				array(
					'slug'  => 'lets-review-blocks',
					'title' => __( "Let's Review", 'lets-review-blocks' ),
				),
			)
		);
	}

	function lets_review_block_cb( $attr = '' ) {
		$attr['itemReviewed'] = empty( $attr['itemReviewed'] ) ? 'Organization' : $attr['itemReviewed'];
		return self::lets_review_block( $attr );
	}

	function lets_review_visitor_rating_cb( $attr = '' ) {
		return self::lets_review_visitor_rating_block( $attr );
	}

	function lets_review_comment_averages_cb( $attr = '' ) {
		return self::lets_review_comment_averages_block( $attr );
	}

	function lets_review_block_callbacks() {
		if ( function_exists( 'register_block_type' ) ) {
			register_block_type(
				'lets-review/block-review',
				array(
					'render_callback' => array( $this, 'lets_review_block_cb' ),
				)
			);
			register_block_type(
				'lets-review/block-visitor-ratings',
				array(
					'attributes'      => array(
						'skin'              => array(
							'type'    => 'string',
							'default' => '1',
						),
						'hideTitleBox'      => array(
							'type'    => 'boolean',
							'default' => false,
						),
						'title'             => array(
							'type'    => 'string',
							'default' => '',
						),
						'design'            => array(
							'type'    => 'string',
							'default' => '1',
						),
						'scoreType'         => array(
							'type'    => 'string',
							'default' => '1',
						),
						'accent'            => array(
							'type'    => 'string',
							'default' => '#f8d92f',
						),
						'uid'               => array(
							'type'    => 'integer',
							'default' => 123,
						),
						'fiID'              => array(
							'type' => 'integer',
						),
						'fiThumb'           => array(
							'type' => 'string',
						),
						'itemReviewed'      => array(
							'type'    => 'string',
							'default' => 'Organization',
						),
						'schemaDirector'    => array(
							'type'    => 'string',
							'default' => '',
						),
						'schemaMpn'         => array(
							'type'    => 'string',
							'default' => '',
						),
						'schemaSku'         => array(
							'type'    => 'string',
							'default' => '',
						),
						'schemaBrand'       => array(
							'type'    => 'string',
							'default' => '',
						),
						'schemaDescription' => array(
							'type'    => 'string',
							'default' => '',
						),
						'schemaDateCreated' => array(
							'type'    => 'date',
							'default' => '',
						),
						'skinBG'            => array(
							'type'    => 'string',
							'default' => '#111',
						),
						'iconCode'          => array(
							'type'    => 'string',
							'default' => '',
						),
						'skinText'          => array(
							'type'    => 'string',
							'default' => '#fff',
						),
					),
					'render_callback' => array( $this, 'lets_review_visitor_rating_cb' ),
				)
			);
			register_block_type(
				'lets-review/block-comment-averages',
				array(
					'attributes'      => array(
						'pid'        => array(
							'type' => 'string',
						),
						'title'      => array(
							'type'    => 'string',
							'default' => esc_html__( 'Average User Ratings', 'zeen' ),
						),
						'isguten'    => array(
							'type'    => 'boolean',
							'default' => false,
						),
						'bgID'       => array(
							'type' => 'integer',
						),
						'scoreType'  => array(
							'type'    => 'string',
							'default' => '1',
						),
						'bgThumb'    => array(
							'type' => 'string',
						),
						'skinBG'     => array(
							'type'    => 'string',
							'default' => '#111',
						),
						'skinText'   => array(
							'type'    => 'string',
							'default' => '#fff',
						),
						'skinTitles' => array(
							'type'    => 'string',
							'default' => '#ead125',
						),
						'accent'     => array(
							'type'    => 'string',
							'default' => '#f8d92f',
						),
						'design'     => array(
							'type'    => 'string',
							'default' => '1',
						),
						'skin'       => array(
							'type'    => 'string',
							'default' => '1',
						),
					),
					'render_callback' => array( $this, 'lets_review_comment_averages_cb' ),
				)
			);
		}
	}

	function lets_review_bg( $args = array() ) {
		if ( ( 3 != $args['design'] && 4 != $args['design'] && 6 != $args['design'] && empty( $args['bgOverride'] ) ) || empty( $args['bgID'] ) ) {
			return;
		}
		if ( 6 == $args['design'] ) {
			echo '<div class="lets-review-block lets-review-block__img"">';
			echo wp_get_attachment_image( $args['bgID'], 'full' );
			echo '</div>';
		} else {
			echo '<div class="lets-review-block lets-review-block__bg">';
			echo wp_get_attachment_image( $args['bgID'], 'full' );
			echo '</div>';
		}
	}
	static function lets_review_list( $args = array() ) {
		$blocks = new Lets_Review_Blocks();
		if ( empty( $args['echo'] ) ) {
			ob_start();
		}
		$lists         = array();
		$args['block'] = 90;
		$args['order'] = empty( $args['order'] ) ? 1 : $args['order'];
		$args          = Lets_Review_Helpers::lets_review_args( $args );
		if ( ! empty( $args['source'] ) ) {
			$args['pids'] = empty( $args['pids'] ) ? '' : $args['pids'];
			$args['cats'] = empty( $args['cats'] ) ? '' : $args['cats'];
			$args['tags'] = empty( $args['tags'] ) ? '' : $args['tags'];
			$args['ppp']  = empty( $args['ppp'] ) ? '' : $args['ppp'];
			$i            = 1;
			$qry_args     = array(
				'post_type'           => Lets_Review_Helpers::lets_review_get_post_types(),
				'fields'              => 'ids',
				'ignore_sticky_posts' => true,
			);
			if ( 1 == $args['order'] ) {
				$qry_args['orderby']    = 'post__in';
				$qry_args['meta_key']   = '_lets_review_onoff';
				$qry_args['meta_value'] = 1;
			} elseif ( 3 == $args['order'] ) {
				$qry_args['meta_key']   = '_lets_review_onoff';
				$qry_args['meta_value'] = 1;
			} else {
				$qry_args['meta_query'] = array(
					array(
						'key'     => $args['type'] > 2 ? '_lets_review_user_rating' : '_lets_review_final_score_100',
						'value'   => '',
						'compare' => '!=',
					),
					array(
						'key'     => '_lets_review_onoff',
						'value'   => '1',
						'compare' => '==',
					),
					array(
						'key'     => '_lets_review_type',
						'value'   => $args['type'],
						'compare' => '==',
					),
				);
				$qry_args['orderby']    = 'meta_value_num';
				$qry_args['order']      = 'DESC';
			}
			if ( 1 == $args['source'] ) {
				$qry_args['post__in'] = explode( ',', $args['pids'] );
			} elseif ( 2 == $args['source'] ) {
				$qry_args['cat']            = $args['cats'];
				$qry_args['posts_per_page'] = $args['ppp'];
			} else {
				$qry_args['tag__in']        = $args['tags'];
				$qry_args['posts_per_page'] = $args['ppp'];
			}
			$qry = new WP_Query( apply_filters( 'lets_review_list_args', $qry_args ) );
			$qry = $qry->posts;
			foreach ( $qry as $pid ) {
				$fi     = get_post_meta( $pid, '_lets_review_media_use_fi', true );
				$fi_id  = get_post_meta( $pid, '_lets_review_fi', true );
				$fi     = 1 == $fi || empty( $fi_id ) ? get_post_thumbnail_id( $pid ) : $fi_id;
				$format = get_post_meta( $pid, '_lets_review_format', true );
				$score  = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
					array(
						'score'     => $args['type'] > 2 ? get_post_meta( $pid, '_lets_review_user_rating', true ) : get_post_meta( $pid, '_lets_review_final_score', true ),
						'scoreType' => $args['type'] > 2 ? 1 : $format,
					)
				);
				$pros   = Lets_Review_Helpers::lets_review_cleanup_pros_cons( get_post_meta( $pid, '_lets_review_pros', true ), 'positive' );
				$cons   = Lets_Review_Helpers::lets_review_cleanup_pros_cons( get_post_meta( $pid, '_lets_review_cons', true ), 'negative' );
				$aff    = Lets_Review_Helpers::lets_review_cleanup_aff( get_post_meta( $pid, '_lets_review_aff_buttons', true ) );
				$bg_id  = 1 != $args['design'] ? $fi : '';
				if ( get_post_meta( $pid, '_lets_review_title_use_post', true ) == 1 ) {
					$title = get_the_title( $pid );
				} else {
					$title = get_post_meta( $pid, '_lets_review_title', true );
					$title = empty( $title ) ? get_the_title( $pid ) : $title;
				}
				$accent = get_post_meta( $pid, '_lets_review_color', true );
				if ( get_theme_mod( 'lr_override_accent_color_onoff' ) == true ) {
					$source = get_theme_mod( 'reviews_color_source', 1 );
					if ( 1 == $source ) {
						$categories_list = get_the_category( $pid );
						if ( ! empty( $categories_list ) ) {
							$accent = get_term_meta( $categories_list[0]->term_id, 'zeen_color', true ) != '' ? get_term_meta( $categories_list[0]->term_id, 'zeen_color', true ) : $accent;
						}
					} elseif ( 2 == $source ) {
						$accent = get_theme_mod( 'lr_override_accent_color', '#f8d92f' );
					}
				}
				$list_args = array(
					'countdown'        => $args['countdown'],
					'count'            => $i,
					'block'            => $args['block'],
					'scoreStyle'       => 1 != $args['design'] ? 'border-color' : '',
					'title'            => $title,
					'scoreTitle'       => get_post_meta( $pid, '_lets_review_subtitle', true ),
					'titleUrl'         => get_permalink( $pid ),
					'fi'               => $fi,
					'bgID'             => $bg_id,
					'bgOverride'       => empty( $bg_id ) ? '' : true,
					'noStyle'          => true,
					'score'            => $score,
					'accent'           => $accent,
					'affBlocks'        => $aff,
					'affTitle'         => get_post_meta( $pid, '_lets_review_aff_title', true ),
					'iconCode'         => get_post_meta( $pid, '_lets_review_custom_icon', true ),
					'imgIconID'        => get_post_meta( $pid, '_lets_review_custom_image', true ),
					'conclusion'       => get_post_meta( $pid, '_lets_review_conclusion', true ),
					'conclusion_title' => get_post_meta( $pid, '_lets_review_conclusion_title', true ),
					'prosconsOff'      => $args['prosconsOff'],
					'pros'             => $pros,
					'prosTitle'        => get_post_meta( $pid, '_lets_review_pros_title', true ),
					'cons'             => $cons,
					'consTitle'        => get_post_meta( $pid, '_lets_review_cons_title', true ),
					'scoreType'        => $format,
					'design'           => $args['design'],
				);

				$lists[] = Lets_Review_Helpers::lets_review_args( $list_args );
				$i++;
			}
		}
		$class  = empty( $args['pid'] ) ? '' : 'lets-review-wrap-' . (int) $args['pid'];
		$class .= ' lets-review--center';
		$class .= ' lets-review-skin-' . $args['skin'];
		$class .= ' lets-review-list-design-' . $args['design'];
		$class .= $args['scoreType'] < 3 ? ' lets-review-score-type__bar' : ' lets-review-score-type__icon';
		if ( empty( $args['conclusion'] ) && empty( $args['conclusionTitle'] ) ) {
			$class .= ' conclusion__off';
		}
		if ( ! empty( $args['prosconsOff'] ) || ( empty( $args['pros'] ) && empty( $args['cons'] ) && empty( $args['prosTitle'] ) && empty( $args['consTitle'] ) ) ) {
			$class .= ' proscons__off';
		}

		echo '<div class="lets-review-block__wrap-90 lr-cf ' . esc_attr( $class ) . '"';
		echo ' data-design="' . (int) $args['design'] . '"';
		echo ' data-score-type="' . (int) $args['scoreType'] . '"';
		echo ' data-skin="' . (int) $args['skin'] . '"';
		echo '>';
		if ( ! empty( $args['title'] ) ) {
			echo '<h2 class="list__main-title">' . lets_review_sanitize_wp_kses( $args['title'] ) . '</h2>';
		}
		echo '<div class="lets-review-lists">';
		foreach ( $lists as $list ) {
			echo '<div class="lets-review-list lets-review-block__wrap">';
			$blocks->lets_review_bg( $list );
			$blocks->lets_review_main_title( $list );
			if ( 1 == $args['design'] && ! empty( $list['fi'] ) ) {
				echo '<div class="lets-review-block lets-review-block__fi lets-review-block__pad">';
				echo '<a href="' . esc_url( $list['titleUrl'] ) . '">';
				echo wp_get_attachment_image( $list['fi'] );
				echo '</a></div>';
			}
			$blocks->lets_review_conclusion( $list );
			$blocks->lets_review_score_output( $list );
			$blocks->lets_review_proscons( $list );
			$blocks->lets_review_aff( $list );
			echo '</div>';
		}
		echo '</div>';
		echo '</div>';
		if ( empty( $args['echo'] ) ) {
			return ob_get_clean();
		}
	}
	static function lets_review_block( $args = array() ) {
		$blocks = new Lets_Review_Blocks();
		if ( empty( $args['echo'] ) ) {
			ob_start();
		}
		$args['block']           = 1;
		$args['ur']              = true;
		$args['reviewType']      = empty( $args['reviewType'] ) ? '' : $args['reviewType'];
		$args['schema_type']     = empty( $args['reviewType'] ) ? 1 : $args['reviewType'];
		$args['pid']             = empty( $args['pid'] ) ? '' : $args['pid'];
		$args['imgIconID']       = empty( $args['imgIconID'] ) ? '' : $args['imgIconID'];
		$args['design']          = empty( $args['design'] ) ? 1 : $args['design'];
		$args['skinBG']          = empty( $args['skinBG'] ) ? '#181818' : $args['skinBG'];
		$args['affTitle']        = empty( $args['affTitle'] ) ? array() : $args['affTitle'];
		$args['affBlocks']       = empty( $args['affBlocks'] ) ? array() : $args['affBlocks'];
		$args['position']        = ! isset( $args['position'] ) ? 'center' : $args['position'];
		$args['aniType']         = empty( $args['aniType'] ) ? 1 : $args['aniType'];
		$args['score']           = ! isset( $args['score'] ) ? '' : $args['score'];
		$args['iconCode']        = ! isset( $args['iconCode'] ) ? '' : $args['iconCode'];
		$args['conclusionTitle'] = empty( $args['conclusionTitle'] ) ? '' : $args['conclusionTitle'];
		$args['conclusion']      = empty( $args['conclusion'] ) ? '' : $args['conclusion'];
		$args['pros']            = empty( $args['pros'] ) ? '' : $args['pros'];
		$args['cons']            = empty( $args['cons'] ) ? '' : $args['cons'];
		$args['prosTitle']       = empty( $args['prosTitle'] ) ? '' : $args['prosTitle'];
		$args['consTitle']       = empty( $args['consTitle'] ) ? '' : $args['consTitle'];
		$args['showScore']       = isset( $args['showScore'] ) ? $args['showScore'] : true;
		$args['showUserRating']  = isset( $args['showUserRating'] ) ? $args['showUserRating'] : '';
		$args['gallery']         = empty( $args['gallery'] ) ? '' : $args['gallery'];
		$args['galleryTitle']    = empty( $args['galleryTitle'] ) ? '' : $args['galleryTitle'];
		$args                    = Lets_Review_Helpers::lets_review_args( $args );
		$final_score             = Lets_Review_Helpers::lets_review_get_ur_final_score( $args );
		$args['ur_score']        = $final_score['score'];
		$args['votes']           = $final_score['votes'];
		$class                   = empty( $args['pid'] ) ? '' : 'lets-review-wrap-' . (int) $args['pid'];
		$class                  .= ' lets-review--' . $args['position'];
		$class                  .= ' lets-review-skin-' . $args['skin'];
		$class                  .= ' lets-review-design-' . $args['design'];
		$class                  .= ' lets-review-ani-' . $args['aniType'];
		$class                  .= ' lets-review-score-type-' . $args['scoreType'];
		$class                  .= ' lets-review-type-' . $args['reviewType'];
		$class                  .= $args['scoreType'] < 3 ? ' lets-review-score-type__bar' : ' lets-review-score-type__icon';
		if ( 'right' == $args['position'] || 'left' == $args['position'] ) {
			$class .= ' lets-review--side';
		}
		if ( isset( $args['location'] ) && 5 == $args['location'] ) {
			$class .= ' lets-review__output-5';
		}
		if ( empty( $args['conclusion'] ) && empty( $args['conclusionTitle'] ) ) {
			$class .= ' conclusion__off';
		}
		if ( empty( $args['pros'] ) && empty( $args['cons'] ) && empty( $args['prosTitle'] ) && empty( $args['consTitle'] ) ) {
			$class .= ' proscons__off';
		}

		$args['skinText'] = empty( $args['skinText'] ) ? '' : $args['skinText'];
		if ( 3 == $args['skin'] ) {
			$class             .= ' lets-review-' . (int) $args['uid'];
			$args['skinText']   = empty( $args['skinText'] ) ? '#fff' : $args['skinText'];
			$args['skinTitles'] = empty( $args['skinTitles'] ) ? '#ead125' : $args['skinTitles'];
		}
		echo '<div class="lets-review-block__wrap lets-review-block__wrap-10 lr-cf ' . esc_attr( $class ) . '"';
		if ( 3 == $args['skin'] ) {
			echo ' style="background:' . esc_attr( $args['skinBG'] ) . '; color: ' . esc_attr( $args['skinText'] ) . '"';
		}
		echo ' data-design="' . (int) $args['design'] . '"';
		echo ' data-score-type="' . (int) $args['scoreType'] . '"';
		echo ' data-skin="' . (int) $args['skin'] . '"';
		echo '>';
		$blocks->lets_review_bg( $args );
		echo apply_filters( 'lets_review_start_review', '' );
		$blocks->lets_review_main_title( $args );
		$blocks->lets_review_conclusion( $args );
		$blocks->lets_review_crits( $args );
		$blocks->lets_review_proscons( $args );
		if ( ! empty( $args['showScore'] ) ) {
			$blocks->lets_review_score_output( $args );
		}
		$blocks->lets_review_gallery( $args );
		$blocks->lets_review_aff( $args );
		echo apply_filters( 'lets_review_end_review', '' );
		echo '</div>';
		Lets_Review_Helpers::lets_review_schema( $args );
		if ( empty( $args['echo'] ) ) {
			return ob_get_clean();
		}
	}

	function lets_review_leave_comment_review_button( $args = array() ) {
		if ( empty( $args['comment_review'] ) ) {
			return;
		}
		global $post;
		$args['pid'] = empty( $args['pid'] ) ? $post->ID : $args['pid'];
		echo '<a class="leave__review lr-button" href="' . esc_url( get_comments_link( $args['pid'] ) ) . '">';
		esc_html_e( 'Leave A Review', 'lets-review' );
		echo '</a>';
	}

	function lets_review_score_output( $args = array() ) {
		if ( ! empty( $args['reviewType'] ) && 3 == $args['reviewType'] ) {
			$args['score'] = $args['ur_score'];
		}
		if ( empty( $args['score'] ) ) {
			return;
		}
		$accent_prop = 3 == $args['design'] || ( ! empty( $args['scoreStyle'] ) && 'border-color' == $args['scoreStyle'] ) ? 'border-color' : 'background';
		if ( $args['scoreType'] > 2 ) {
			$args['score'][ $args['scoreTypeProp'] ] = number_format( $args['score'][ $args['scoreTypeProp'] ], 1 ) + 0;
		}
		echo '<div class="lets-review-block lets-review-block__final-score lets-review-block__final-score-type-' . (int) $args['scoreType'];

		if ( empty( $args['padding_off'] ) ) {
			echo ' lets-review-block__pad';
		}
		if ( $args['score']['outof100'] < 10 ) {
			echo ' score-level-1';
			if ( $args['score']['outof100'] < 1 ) {
				echo ' score-level-0';
			}
		} else {
			$level = substr( $args['score']['outof100'], 0, -1 );
			echo ' score-level-' . (int) $level;
		}

		echo '">';
		echo '<div class="score__wrap lr-all-c';
		if ( ! empty( $args['scoreTitle'] ) ) {
			echo ' score__wrap__with__title';
		}
		echo '"';

		echo apply_filters( 'lets_review_before_final_score', '' );
		if ( empty( $args['style_off'] ) ) {
			echo ' style="' . esc_attr( $accent_prop ) . ':' . esc_attr( $args['accent'] ) . '; color: ' . esc_attr( $args['skinFinalScore'] ) . '"';
		}
		echo '>';
		if ( ( 4 == $args['scoreType'] && isset( $args['iconCode'] ) || ( 5 == $args['scoreType'] && isset( $args['imgIconID'] ) ) || 3 == $args['scoreType'] ) && isset( $args['scoreTypeProp'] ) && isset( $args['score'][ $args['scoreTypeProp'] ] ) ) {
			$args['icon_style_off'] = true;
			$this->lets_review_bars_icons_output( $args, $args['score'] );
		}
		echo '<div class="score">' . (float) min( $this->lets_review_score_output_calc( $args ), $args['max'] ) . '</div>';
		if ( ! empty( $args['scoreTitle'] ) ) {
			echo '<div class="score__title lr-font-h">';
			if ( 20 == $args['block'] ) {
				echo (int) $args['votes'] . ' ';
			}
			echo lets_review_sanitize_wp_kses( $args['scoreTitle'] );
			echo '</div>';
		}
		echo apply_filters( 'lets_review_after_final_score', '' );
		echo '</div>';
		echo '</div>';
	}

	function lets_review_score_output_calc( $args = array() ) {
		$output = $args['score'][ $args['scoreTypeProp'] ];
		if ( $args['scoreType'] > 1 ) {
			$output = round( $output, 1 );
		} else {
			$output = (int) $output;
		}
		return $output;
	}

	function lets_review_proscons_part_output( $type = '', $title = '', $loop = array(), $args = array() ) {
		echo '<div class="lets-review-block__' . esc_attr( $type ) . '">';
		if ( ! empty( $title ) ) {
			echo '<div class="proscons__title lets-review-block__title lr-font-h" style="' . esc_attr( $this->lets_review_styles( $args ) ) . '">' . lets_review_sanitize_wp_kses( $title ) . '</div>';
		}
		if ( ! empty( $loop ) ) {
			foreach ( $loop as $key ) {
				if ( ! empty( $key['title'] ) ) {
					echo '<div class="lets-review-block__procon lets-review-block__' . esc_attr( substr( $type, 0, -1 ) ) . '">';
					echo lets_review_sanitize_wp_kses( $key['title'] );
					echo '</div>';
				}
			}
		}
		echo '</div>';
	}
	function lets_review_proscons( $args = array() ) {
		if ( ! empty( $args['prosconsOff'] ) ) {
			return;
		}
		$pros       = empty( $args['pros'] ) ? '' : $args['pros'];
		$cons       = empty( $args['cons'] ) ? '' : $args['cons'];
		$pros_title = empty( $args['prosTitle'] ) ? '' : $args['prosTitle'];
		$cons_title = empty( $args['consTitle'] ) ? '' : $args['consTitle'];
		if ( empty( $cons ) && empty( $pros ) && empty( $pros_title ) && empty( $cons_title ) ) {
			return;
		}
		echo '<div class="lets-review-block lets-review-block__proscons lets-review-block__pad">';
		$this->lets_review_proscons_part_output( 'pros', $pros_title, $pros, $args );
		$this->lets_review_proscons_part_output( 'cons', $cons_title, $cons, $args );
		echo '</div>';
	}

	function lets_review_conclusion( $args = array() ) {
		$conclusion_title = empty( $args['conclusionTitle'] ) ? '' : $args['conclusionTitle'];
		$conclusion       = empty( $args['conclusion'] ) ? '' : $args['conclusion'];
		if ( empty( $conclusion_title ) && empty( $conclusion ) ) {
			return;
		}
		echo '<div class="lets-review-block lets-review-block__conclusion__wrap lets-review-block__pad">';
		if ( ! empty( $conclusion_title ) ) {
			echo '<div class="lets-review-block__conclusion__title lets-review-block__title lr-font-h" style="' . esc_attr( $this->lets_review_styles( $args ) ) . '">' . lets_review_sanitize_wp_kses( $conclusion_title ) . '</div>';
		}
		if ( ! empty( $conclusion ) ) {
			echo '<div class="lets-review-block__conclusion">' . lets_review_sanitize_wp_kses( $conclusion ) . '</div>';
		}
		echo '</div>';
	}

	function lets_review_crits( $args = array() ) {
		if ( 3 == $args['design'] || 4 == $args['design'] || 5 == $args['design'] ) {
			return;
		}
		$args['crits'] = empty( $args['crits'] ) ? array() : $args['crits'];
		if ( ! empty( $args['crits'] ) || 3 === (int) $args['reviewType'] || 1 === (int) $args['reviewType'] ) {
			$i = 0;
			echo '<div class="lets-review-block lets-review-block__crits';
			if ( empty( $args['isguten'] ) ) {
				echo ' lets-review-unseen';
			}
			echo '">';
			$this->lets_review_leave_comment_review_button( $args );
			foreach ( $args['crits'] as $key => $value ) {
				if ( empty( $value['title'] ) && ! isset( $value[ $args['scoreTypeProp'] ] ) ) {
					continue;
				}
				echo '<div class="lets-review-block__crit';
				if ( 6 == $args['design'] ) {
					if ( $value['outof100'] < 34 ) {
						echo ' level-1';
					} elseif ( $value['outof100'] < 75 ) {
						echo ' level-5';
					} else {
						echo ' level-10';
					}
					if ( $value['outof100'] < 10 ) {
						echo ' level-granular-0';
					} else {
						echo ' level-granular-' . (int) substr( $value['outof100'], 0, -1 );
					}
				}
				if ( ! empty( $value['rating'] ) && 'false' !== $value['rating'] ) {
					echo ' lr-user__rating lr-tip';
				}
				echo '"';
				if ( ! empty( $value['rating'] ) ) {
					echo ' data-title="';
					esc_attr_e( 'Your Rating', 'lets-review' );
					echo '"';

					echo ' data-title-2="';
					esc_attr_e( 'Change Your Rating', 'lets-review' );
					echo '"';
				}
				echo ' data-score="' . (int) $value['outof100'] . '"';
				echo ' data-crit="' . (int) $i . '"';
				echo '>';
				if ( ! empty( $value['title'] ) ) {
					echo '<div class="lets-review-block__crit__title lr-font-h"';
					if ( empty( $args['comment_review'] ) ) {
						echo ' style="' . esc_attr( $this->lets_review_styles( $args ) ) . '"';
					}
					echo '>' . lets_review_sanitize_wp_kses( $value['title'] ) . '</div>';
				}

				if ( isset( $args['scoreTypeProp'] ) && isset( $value[ $args['scoreTypeProp'] ] ) ) {
					$this->lets_review_bars_icons_output( $args, $value );
				}
				echo '</div>';
				$i++;
			}
			$this->lets_review_reader_rating( $args, true );
			echo '</div>';
		}
	}
	function lets_review_bars_icons_output( $args = array(), $value = array() ) {
		if ( empty( $value ) ) {
			$value = array(
				'outof100' => 0,
				'outof10'  => 0,
				'outof5'   => 0,
			);
		} else {
			$double_decimal = apply_filters( 'lets_review_stars_double_decimal', 'off' ) === 'on' ? 2 : 1;

			$value['outof100'] = isset( $value['outof100'] ) ? (int) $value['outof100'] : '';
			$value['outof10']  = isset( $value['outof10'] ) ? round( $value['outof10'], 1 ) : '';
			$value['outof5']   = isset( $value['outof5'] ) ? round( $value['outof5'], $double_decimal ) : '';
		}
		$score_type_name = $args['scoreType'] < 3 ? 'bar' : 'icon';
		$filters         = self::lets_review_block_filters();
		if ( $args['scoreType'] < 3 ) {
			echo '<div class="lets-review-block__crit__score">' . lets_review_sanitize_wp_kses( min( $value[ $args['scoreTypeProp'] ], $args['max'] ) ) . '</div>';
		}
		echo '<div class="score-overlay-wrap score-overlay-wrap__' . esc_attr( $score_type_name ) . '"';
		if ( $args['scoreType'] > 2 && empty( $args['icon_style_off'] ) ) {
			echo ' style="color: ' . $args['accent'] . ';"';
		}
		echo '>';
		if ( $args['scoreType'] < 3 ) {
			echo '<div class="score-overlay" style="width:' . (int) min( $value['outof100'], 100 ) . '%;background:' . esc_attr( $args['accent'] ) . ';"></div>';
		} else {
			$icon_code = 4 == $args['scoreType'] ? $args['iconCode'] : '<i class="' . $filters['stars'] . '"></i>';
			if ( ! empty( $args['imgIconID'] ) ) {
				$icon_code = 5 == $args['scoreType'] ? wp_get_attachment_image( $args['imgIconID'], 'thumbnail' ) : $icon_code;
			}
			echo lets_review_sanitize_wp_kses( str_repeat( $icon_code, $filters['icon_quantity'] ) );
			echo '<div class="score-overlay" style="width:' . (int) min( ( $value['outof100'] - 100 ) * -1, 100 ) . '%"></div>';
		}
		echo '</div>';
	}
	public static function lets_review_block_filters() {
		$output                  = array();
		$output['stars']         = apply_filters( 'lets_review_stars', 'fas fa-star' );
		$output['icon_quantity'] = apply_filters( 'lets_review_icon_quantity', 5 );
		return $output;
	}

	function lets_review_main_title( $args = array() ) {
		if ( ( empty( $args['fiID'] ) && empty( $args['title'] ) ) || ! empty( $args['hideTitleBox'] ) ) {
			return;
		}
		echo '<div class="lets-review-block lets-review-block__main-title lr-vc lets-review-block__pad"';
		if ( $args['scoreType'] > 2 && $args['design'] < 3 && empty( $args['noStyle'] ) ) {
			echo ' style="background-color: ' . esc_attr( $args['accent'] ) . '"';
		}
		echo '>';
		if ( ! empty( $args['fiID'] ) && ! ( 3 == $args['design'] || 4 == $args['design'] || 6 == $args['design'] ) ) {
			echo '<div class="lets-review-block__mask lr-vc">';
			echo wp_get_attachment_image( $args['fiID'], 'thumbnail' );
			echo '</div>';
		}
		if ( ! empty( $args['countdown'] ) && ! empty( $args['count'] ) ) {
			echo '<div class="lets-review-countdown lets-review-block">';
			echo (int) $args['count'];
			echo '</div>';
		}
		if ( ! empty( $args['title'] ) ) {
			echo '<' . apply_filters( 'lets_review_main_title_tag', 'div' ) . ' class="lets-review-block__title lr-font-h" style="' . esc_attr( $this->lets_review_styles( $args ) ) . '">';
			if ( ! empty( $args['titleUrl'] ) ) {
				echo '<a href="' . esc_url( $args['titleUrl'] ) . '">';
			}
			echo lets_review_sanitize_wp_kses( $args['title'] );
			if ( ! empty( $args['titleUrl'] ) ) {
				echo '</a>';
			}
			echo '</' . apply_filters( 'lets_review_main_title_tag', 'div' ) . '>';
		}
		echo '</div>';
	}

	function lets_review_gallery( $args = array() ) {
		if ( empty( $args['gallery'] ) ) {
			return;
		}
		echo '<div class="lets-review-block lets-review-block__gallery lets-review-block__pad">';
		if ( ! empty( $args['galleryTitle'] ) ) {
			echo '<div class="lets-review-block__title lr-font-h" style="' . esc_attr( $this->lets_review_styles( $args ) ) . '">';
			echo lets_review_sanitize_wp_kses( $args['galleryTitle'] );
			echo '</div>';
		}
		$pid = empty( $args['pid'] ) ? '' : $args['pid'];
		echo '<div id="lr-gallery-uid-' . (int) $pid . '" class="lets-review-block__images lr-all-c">';
		$i = 0;
		foreach ( $args['gallery'] as $key ) {
			$src = wp_get_attachment_image_src( $key['id'], 'full' );
			if ( empty( $src[0] ) ) {
				continue;
			}
			echo '<div class="lets-review-block__image">';
			echo '<a href="' . esc_url( $src[0] ) . '" class="lets-review-lightbox" data-index="' . (int) $i . '" data-gallery-uid="' . (int) $pid . '">';
			echo wp_get_attachment_image( $key['id'] );
			echo '</a>';
			echo '</div>';
			$i++;
		}
		echo '</div>';
		echo '</div>';
	}

	function lets_review_aff( $args = array() ) {
		$extra = empty( $args['new_tab'] ) ? '' : ' target="_blank"';
		if ( 3 == $args['skin'] ) {
			$extra .= ' style="border-color:' . esc_attr( $args['accent'] ) . ';"';
		}
		if ( 6 == $args['design'] ) {
			$extra .= ' style="background:' . esc_attr( $args['accent'] ) . ';"';
		}
		if ( ! empty( $args['affBlocks'] ) ) {
			echo '<div class="lets-review-block lets-review-block__aff lets-review-block__pad">';
			if ( ! empty( $args['affTitle'] ) ) {
				echo '<div class="lets-review-block__title lr-font-h" style="' . esc_attr( $this->lets_review_styles( $args ) ) . '">' . lets_review_sanitize_wp_kses( $args['affTitle'] ) . '</div>';
			}
			echo '<div class="aff-button-wrap';
			if ( ! empty( $args['sc'] ) ) {
				echo ' aff-button-sc';
			}
			echo '">';
			$shopping_icon = get_option( 'lets_review_gen_type_shopping_onoff' ) == 1 ? get_option( 'lets_review_gen_type_shopping_icon' ) : '<i class="' . esc_attr( apply_filters( 'lets_review_aff_icon_1_class', 'fas fa-shopping-cart' ) ) . '"></i>';
			if ( substr( $shopping_icon, 0, 4 ) === '<svg' ) {
				$shopping_icon = '<span class="svg-wrap lr-all-c">' . $shopping_icon . '</span>';
			}
			$i_wrap = '<div class="i-wrap" style="background:' . esc_attr( $args['accent'] );
			if ( ! empty( $args['sc'] ) ) {
				$i_wrap .= '!important';
			}
			$i_wrap .= ';">' . $shopping_icon . '<i class="' . esc_attr( apply_filters( 'lets_review_aff_icon_2_class', 'fas fa-long-arrow-alt-right' ) ) . '"></i></div>';

			foreach ( $args['affBlocks'] as $key => $value ) {
				if ( ! empty( $value['content'] ) ) {
					$content = $value['content'];
					preg_match_all( '/<a[^>]+href=([\'"])(?<href>.+?)\1[^>]*>/i', $content, $result );
					$result = array_filter( $result );
					if ( ! empty( $result ) ) {
						$content = str_replace( '">', '" class="aff-button lr-button" target="_blank" rel="noreferrer noopener nofollow"' . $extra . ' ><span class="button-title">', $content );
						$content = str_replace( '</a', '</span>' . $i_wrap . '</a', $content );
					} else {
						$content = '<div class="aff-button lr-button"' . esc_attr( $extra ) . '><span class="button-title">' . $content . '</span>' . $i_wrap . '</div>';
					}

					echo lets_review_sanitize_wp_kses( $content );
				}
			}
			echo '</div>';
			echo '</div>';
		}
	}

	static function lets_review_visitor_rating_block( $args = array() ) {
		$blocks = new Lets_Review_Blocks();
		if ( empty( $args['echo'] ) ) {
			ob_start();
		}

		$args['block']          = 20;
		$args['ur']             = true;
		$args['schema_type']    = 3;
		$args['showUserRating'] = true;
		$args['uid']            = empty( $args['uid'] ) ? 1 : $args['uid'];
		$args['title']          = empty( $args['title'] ) ? '' : $args['title'];
		$args['hideTitleBox']   = empty( $args['hideTitleBox'] ) ? '' : $args['hideTitleBox'];
		$args['design']         = empty( $args['design'] ) ? 1 : $args['design'];
		$args['scoreType']      = empty( $args['format'] ) ? 1 : $args['format'];
		$args['skinBG']         = empty( $args['skinBG'] ) ? '#181818' : $args['skinBG'];
		$args['scoreTitle']     = esc_html__( 'Votes', 'lets-review' );
		$final_score            = Lets_Review_Helpers::lets_review_get_ur_final_score( $args );
		$args['ur_score']       = $final_score['score'];
		$args['score']          = $final_score['score'];
		$args['votes']          = $final_score['votes'];
		$args['skinText']       = empty( $args['skinText'] ) ? '' : $args['skinText'];
		$args                   = Lets_Review_Helpers::lets_review_args( $args );
		$class                  = empty( $args['pid'] ) ? '' : ' lets-review-wrap-' . (int) $args['pid'];
		$class                 .= ' lets-review-skin-' . $args['skin'];
		$class                 .= ' lets-review-design-' . $args['design'];
		$class                 .= ' lets-review-score-type-' . $args['scoreType'];
		$class                 .= $args['scoreType'] < 3 ? ' lets-review-score-type__bar' : ' lets-review-score-type__icon';
		if ( 3 == $args['skin'] ) {
			$class             .= ' lets-review-' . (int) $args['uid'];
			$args['skinText']   = empty( $args['skinText'] ) ? '#fff' : $args['skinText'];
			$args['skinTitles'] = empty( $args['skinTitles'] ) ? '#ead125' : $args['skinTitles'];
		}
		echo '<div class="lets-review-block__wrap lets-review-block__wrap-20 lr-cf' . esc_attr( $class ) . '"';
		if ( 3 == $args['skin'] ) {
			echo ' style="background:' . esc_attr( $args['skinBG'] ) . '; color: ' . esc_attr( $args['skinText'] ) . '"';
		}
		echo ' data-design="' . (int) $args['design'] . '"';
		echo ' data-score-type="' . (int) $args['scoreType'] . '"';
		echo ' data-skin="' . (int) $args['skin'] . '"';
		echo '>';
		echo apply_filters( 'lets_review_start_visitor_rating', '' );
		$blocks->lets_review_main_title( $args );
		$blocks->lets_review_reader_rating( $args );
		if ( ! empty( $args['show_score_box'] ) && 'off' != $args['show_score_box'] ) {
			$blocks->lets_review_conclusion( $args );
			$blocks->lets_review_score_output( $args );
		}
		echo apply_filters( 'lets_review_end_visitor_rating', '' );
		echo '</div>';
		Lets_Review_Helpers::lets_review_schema( $args );
		if ( empty( $args['echo'] ) ) {
			return ob_get_clean();
		}
	}

	function lets_review_reader_rating( $args = array(), $in_block = '' ) {
		if ( empty( $args['ur'] ) || empty( $args['showUserRating'] ) ) {
			return;
		}
		$cook             = isset( $_COOKIE['lr_block_rating'] ) ? json_decode( stripslashes( html_entity_decode( $_COOKIE['lr_block_rating'] ) ), true ) : array();
		$cook             = is_array( $cook ) ? $cook : array();
		$voted            = isset( $cook[ $args['uid'] ] ) ? true : '';
		$args['ur_score'] = empty( $args['ur_score'] ) ? 0 : $args['ur_score'];
		$args['votes']    = empty( $args['votes'] ) ? 0 : $args['votes'];
		$vote_txt         = sprintf( _n( 'Vote', 'Votes', $args['votes'], 'lets-review' ), $args['votes'] );
		$stop             = get_option( 'lets_review_gen_rating_permission' ) == 2 && ! is_user_logged_in();
		echo '<div class="lets-review-block__user_rating with__uid';
		if ( empty( $in_block ) ) {
			echo ' lets-review-block';
		}
		if ( 20 == $args['block'] && 6 != $args['design'] ) {
			echo ' lets-review-block__pad';
		}
		echo '" data-uid="' . (int) $args['uid'] . '"';

		if ( ! empty( $args['pid'] ) ) {
			echo ' data-is-pid="true"';
		} else {
			echo ' data-is-pid="false"';
		}
		echo '>';
		echo '<div class="lets-review-block__crit lr-tip';
		if ( empty( $stop ) ) {
			echo ' lr-user__rating';
		}
		if ( 6 == $args['design'] ) {
			if ( 20 == $args['block'] ) {
				echo ' lets-review-block__pad';
			}
			if ( $args['ur_score']['outof100'] < 34 ) {
				echo ' level-1';
			} elseif ( $args['ur_score']['outof100'] < 75 ) {
				echo ' level-5';
			} else {
				echo ' level-10';
			}
		}
		if ( ! empty( $voted ) || ! empty( $stop ) ) {
			echo ' lr-user__rated';
		}
		echo '"';
		echo ' data-title="';
		if ( empty( $voted ) ) {
			if ( ! empty( $stop ) ) {
				esc_attr_e( 'You need to be logged in to vote', 'lets-review' );
			} else {
				esc_attr_e( 'Your Rating', 'lets-review' );
			}
		} else {
			esc_attr_e( 'Change Your Rating', 'lets-review' );
		}
		echo '"';
		echo ' data-width-dir="' . esc_attr( $args['scoreType'] < 3 ? 'l' : 'r' ) . '"';
		if ( ! empty( $voted ) && isset( $cook[ $args['uid'] ]['outof100'] ) ) {
			echo ' data-score-u="' . (float) $cook[ $args['uid'] ]['outof100'] . '"';
		}

		$double_decimal = apply_filters( 'lets_review_stars_double_decimal', 'off' ) === 'on' ? 2 : 1;
		echo ' data-score-a="' . (int) $args['ur_score']['outof100'] . '"';
		echo ' data-score-b="' . (float) round( $args['ur_score']['outof10'], 1 ) . '"';
		echo ' data-score-c="' . (float) round( $args['ur_score']['outof5'], $double_decimal ) . '"';
		echo '>';
		echo '<div class="lets-review-block__crit__title lr-font-h" style="' . esc_attr( $this->lets_review_styles( $args ) ) . '">';
		$base_reader_title = get_option( 'lets_review_gd_reader_text' );
		if ( empty( $base_reader_title ) ) {
			echo esc_html__( 'Reader Rating', 'lets-review' );
		} else {
			echo lets_review_sanitize_wp_kses( $base_reader_title );
		}
		echo '<span class="vote__count">' . esc_html( $args['votes'] . ' ' . $vote_txt ) . '</span></div>';
		$this->lets_review_bars_icons_output( $args, $args['ur_score'] );
		echo '</div>';
		echo '</div>';
	}

	public static function lets_review_comment_averages_block( $args = array() ) {
		$blocks                 = new Lets_Review_Blocks();
		$args['block']          = 30;
		$args['schema_type']    = 3;
		$args['comment_review'] = true;
		$args['design']         = empty( $args['design'] ) ? 6 : $args['design'];
		$args['scoreTitle']     = esc_html__( 'User Average', 'lets-review' );
		$args['pid']            = empty( $args['pid'] ) ? 1 : $args['pid'];
		$args['reviewType']     = empty( $args['reviewType'] ) ? '' : $args['reviewType'];
		$args['uid']            = empty( $args['uid'] ) ? $args['pid'] : $args['uid'];
		$args['position']       = ! isset( $args['position'] ) ? 'center' : $args['position'];
		$args['aniType']        = empty( $args['aniType'] ) ? 1 : $args['aniType'];
		$args                   = Lets_Review_Helpers::lets_review_args( $args );
		$class                  = empty( $args['pid'] ) ? '' : 'lets-review-wrap-' . (int) $args['pid'];
		$class                 .= ' lets-review--' . $args['position'];
		$class                 .= ' lets-review-skin-' . $args['skin'];
		$class                 .= ' lets-review-design-' . $args['design'];
		$class                 .= ' lets-review-ani-' . $args['aniType'];
		$class                 .= ' lets-review-score-type-' . $args['scoreType'];
		$class                 .= $args['scoreType'] < 3 ? ' lets-review-score-type__bar' : ' lets-review-score-type__icon';
		if ( 'right' == $args['position'] || 'left' == $args['position'] ) {
			$class .= ' lets-review--side';
		}

		$args['skinText'] = empty( $args['skinText'] ) ? '' : $args['skinText'];
		if ( 3 == $args['skin'] ) {
			$class             .= ' lets-review-' . (int) $args['uid'];
			$args['skinText']   = empty( $args['skinText'] ) ? '#fff' : $args['skinText'];
			$args['skinTitles'] = empty( $args['skinTitles'] ) ? '#ead125' : $args['skinTitles'];
		}

		if ( empty( $args['echo'] ) ) {
			ob_start();
		}
		$args = self::lets_review_comment_averages_final_score( $args );
		echo '<div class="lets-review-block__wrap lets-review-block__wrap-30 lr-cf ' . esc_attr( $class ) . '"';
		if ( 3 == $args['skin'] ) {
			echo ' style="background:' . esc_attr( $args['skinBG'] ) . '; color: ' . esc_attr( $args['skinText'] ) . '"';
		}
		echo ' data-design="' . (int) $args['design'] . '"';
		echo ' data-score-type="' . (int) $args['scoreType'] . '"';
		echo ' data-skin="' . (int) $args['skin'] . '"';
		echo '>';
		$blocks->lets_review_bg( $args );
		$blocks->lets_review_main_title( $args );
		$blocks->lets_review_crits( $args );
		$blocks->lets_review_number_comment_reviews( $args );
		$blocks->lets_review_score_output( $args );
		$blocks->lets_review_aff( $args );
		echo '</div>';
		Lets_Review_Helpers::lets_review_schema( $args );
		if ( 0 == $args['i'] ) {
			return ob_get_clean();
		}

		if ( empty( $args['echo'] ) ) {
			return ob_get_clean();
		}
	}

	function lets_review_styles( $args = array(), $type = 'titles' ) {
		$output = '';
		if ( 'titles' == $type ) {
			$output .= 'color:' . $args['skinTitles'];
		}
		if ( empty( $output ) || 3 != $args['skin'] ) {
			return;
		}
		return $output;
	}

	public static function lets_review_comment_averages_final_score( $args = array() ) {
		$individual_comment_f_score_added_up = 0;
		$args['i']                           = 0;
		$comment_crits_averages              = array();
		$args['format']                      = get_post_meta( $args['pid'], '_lets_review_format', true );
		$comments                            = get_comments(
			array(
				'post_id' => $args['pid'],
			)
		);
		foreach ( $comments as $comment ) {
			if ( empty( $comment->comment_approved ) ) {
				continue;
			}
			$cid                        = $comment->comment_ID;
			$individual_comment_f_score = get_comment_meta( $cid, 'lets_review_ur_f_score', true );
			if ( '' === $individual_comment_f_score ) {
				continue;
			}
			$format = get_comment_meta( $cid, 'lets_review_ur_format', true );
			if ( is_array( $format ) || empty( $format ) ) {
				$format = empty( $format[0] ) ? $args['format'] : $format[0];
			}
			$individual_comment_f_score          = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
				array(
					'score'     => $individual_comment_f_score,
					'scoreType' => $format,
				)
			);
			$individual_comment_f_score_added_up = $individual_comment_f_score_added_up + $individual_comment_f_score['outof100'];
			$crits                               = get_comment_meta( $cid, 'lets_review_ur_criterias', true );

			$crits       = empty( $crits ) ? array() : $crits;
			$crits_total = false;
			$n           = 0;
			foreach ( $crits as $key => $value ) {
				$crit_score = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
					array(
						'score'     => $value['score'],
						'scoreType' => $format,
					)
				);
				if ( 0 == $args['i'] ) {
					$comment_crits_averages[] = array(
						'title'    => $value['title'],
						'outof100' => $crit_score['outof100'],
					);
				} else {
					$comment_crits_averages[ $n ]['outof100'] = $comment_crits_averages[ $n ]['outof100'] + $crit_score['outof100'];
				}
				$n++;
			}
			$args['i']++;
		}
		$args['commentReviewsCount'] = $args['i'];
		$args['votes']               = $args['i'];
		foreach ( $comment_crits_averages as $key => $value ) {
			$comment_crits_averages[ $key ]['outof100'] = (int) ( $value['outof100'] / $args['i'] );
		}
		$args['score']['outof100'] = $args['i'] > 0 ? (int) ( $individual_comment_f_score_added_up / $args['i'] ) : (int) $individual_comment_f_score_added_up;
		$args['score']             = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
			array(
				'score'     => $args['score']['outof100'],
				'scoreType' => 1,
			)
		);
		$args['ur_score']          = $args['score'];
		$args['crits']             = $comment_crits_averages;
		return $args;
	}

	function lets_review_number_comment_reviews( $args = array() ) {
		if ( empty( $args['commentReviewsCount'] ) ) {
			return;
		}
		echo '<div class="lets-review-block lets-review-block__pad lets-review-block__number-reviews">';
		echo '<div class="number-reviews">';
		esc_html_e( 'Based on', 'lets-review' );
		echo ' ' . (int) $args['commentReviewsCount'] . ' ';
		esc_html_e( 'Visitor Reviews', 'lets-review' );
		echo '</div>';
		echo '</div>';
	}
}
